unit Andi;

interface

uses classes, SysUtils, dialogs, Windows, filectrl, forms, dbTables, DBItypes, Shellapi;


function verzeichnis:string;
//gibt das Verzeichnis zurck in dem sich das Programm befindet

function StringIt(I: Integer): string;
// Beliebigen Integer-Typ in String konvertieren

function lastPos(query:string;liste:tstringlist):integer;
//gibt die letzte Zeilennummer einer Liste aus in der der Suchstring query gefunden wurde

procedure ersetzeChar(var zeile:string;alt:char;neu:char);
//ersetzt alle Zeichen alt im String zeile durch neu

procedure auflisten(verzeichnis:string; var liste:Tstringlist);
//Listet alle Dateien auf die sich in Verzeichnis und dessen Unterverzeichnissen befinden

function extractProg(komplettstring:string):string;
// extrahiert den Programmnamen aus einem String

function extractPfad(komplettstring:string):string;
// extrahiert den Pfad aus einem String

procedure WhatStringIs(text:string);
// zeigt einen String in einer Messagebox an

procedure WhatIntIs(nummer:integer);
// zeigt eine Integer-Zahl in einer Messagebox an

function cutS(text:string;laenge:integer):string;
// schneidet einen String der lnger als laenge ist ab und fgt am ende drei punkte an,
// ist der string kleiner werden am ende leerzeichen angehaengt

function repS(text:string; query:string; replacement:string):string;
// ersetzt query durch replacement

function FileVersion : String;
// Liefert die Version der Datei

function vorchar(pair:string;seperator:char):string;
// liefert den Teil vor dem seperator

function nachchar(pair:string;seperator:char):string;
// liefert den Teil nach dem seperator

procedure DateiKopieren(von,nach:string);
// kopiert eine Datei

function shorten(var lang:string):string;

procedure killspace(var s:string);
//lscht #10 #13 <LF> <CR> und ' ' am Anfang eines Strings

function Recno(oTable: TTable): Longint;

function WINbewegen(von,nach:string):boolean;
function WINloeschen(Datei:String):boolean;



implementation

function nachchar(pair:string;seperator:char):string;
var x:integer;
begin
   x:=pos(seperator,pair);
   result:=copy(pair,x+1,length(pair)-x);
end;

function vorchar(pair:string;seperator:char):string;
var x:integer;
begin
   x:=pos(seperator,pair);
   result:=copy(pair,0,x-1);
end;

// ______________________________________________________________________________________________


function FileVersion : String;
Var       VerInfoSize, VerValueSize, Dummy    : DWord;
          VerInfo                             : Pointer;
          VerValue                            : PVSFixedFileInfo;
          V1, V2, V3, V4                      : Integer;
Begin
  // Versions-Info auslesen
  VerInfoSize := GetFileVersionInfoSize(PChar(ParamStr(0)), Dummy);
  GetMem(VerInfo, VerInfoSize);
  GetFileVersionInfo(PChar(ParamStr(0)), 0, VerInfoSize, VerInfo);
  VerQueryValue(VerInfo, '\', Pointer(VerValue), VerValueSize);
  With VerValue^ do
    Begin
      V1 := dwFileVersionMS shr 16;
      V2 := dwFileVersionMS and $FFFF;
      V3 := dwFileVersionLS shr 16;
      V4 := dwFileVersionLS and $FFFF;
    end;
  result := IntToStr(V1)+'.'+IntToStr(V2)+'.'+IntToStr(V3)+'.'+IntToStr(V4);
  FreeMem(VerInfo, VerInfoSize);
End;

// ______________________________________________________________________________________________

function repS(text:string; query:string; replacement:string):string;
var index:integer;
BEGIN
  result:=text;
  index:=POS(query,result);
  WHILE index<>0 DO
  BEGIN
    index:=POS(query,result);
    Delete(result,index,length(query));
    Insert(replacement,result,index);
  END;
END;

// ______________________________________________________________________________________________

function verzeichnis:string;
begin
  result:=extractfilepath(application.exename);
end;

// ______________________________________________________________________________________________

function extractPfad(komplettstring:string):string;
begin
  result:=extractfilepath(komplettstring);
end;

// ______________________________________________________________________________________________

function extractProg(komplettstring:string):string;
begin
  extractfilename(komplettstring);
end;

// ______________________________________________________________________________________________

procedure WhatStringIs(text:string);
begin
  MessageDlg(text, mtInformation,[mbOk], 0);
end;

// ______________________________________________________________________________________________

procedure WhatIntIs(nummer:integer);
begin
  MessageDlg(INTtoSTR(nummer), mtInformation,[mbOk], 0);
end;

// ______________________________________________________________________________________________

function StringIt(I: Integer): string;
{ Beliebigen Integer-Typ in String konvertieren }
begin
  result:=INTtoSTR(i);
end;

// ______________________________________________________________________________________________


function lastPos(query:string;liste:tstringlist):integer;
var line:string;
       i:integer;
begin
  lastpos:=-1;
  FOR i:=0 TO liste.count-1 DO
  BEGIN
    line:=liste[i];
    IF POS(query,line)<>0 THEN lastPos:=i;
  END;
end;


// ______________________________________________________________________________________________

procedure ersetzeChar(var zeile:string;alt:char;neu:char);
var i:integer;
begin
  i:=pos(alt,zeile);
  WHILE i>0 DO
  BEGIN
    delete(zeile,i,1);
    insert(neu,zeile,i);
    i:=pos(alt,zeile);
  END;
end;

// ______________________________________________________________________________________________

function cutS(text:string;laenge:integer):string;
begin
  IF length(text)>laenge
  THEN result:=copy(text,1,laenge-3)+'...'
  ELSE
  BEGIN
    result:=text;
    WHILE length(result)<laenge DO result:=result+' ';
  END;
end;

// ______________________________________________________________________________________________

procedure auflisten(verzeichnis:string; var liste:Tstringlist);
var suchRecord: TsearchRec;

begin
  // wenn das Backslash am Ende fehlt: hinzufgen
  if Verzeichnis[length(Verzeichnis)]<>'\' then Verzeichnis:=Verzeichnis+'\';

  // erstes finden (alle Dateien: $3F)
  if FindFirst(Verzeichnis+'*.*',$3F,SuchRecord)=0 then
    BEGIN
      // falls Verzeichnis: Rekursion
      IF ((SuchRecord.Attr AND faDirectory)>0) AND (SuchRecord.Name<>'.') AND (SuchRecord.Name<>'..')
      THEN auflisten(verzeichnis+SuchRecord.name,liste)
      // ansonsten Datei zur Liste hinzufgen
      ELSE IF (SuchRecord.Name<>'.') and (SuchRecord.Name<>'..')
           THEN Liste.Add(Verzeichnis+SuchRecord.Name);
    END;

  // weitere finden
  WHILE FindNext(SuchRecord)=0 DO
    BEGIN
      // falls Verzeichnis: Rekursion
      IF ((SuchRecord.Attr AND faDirectory)>0) AND (SuchRecord.Name<>'.') AND (SuchRecord.Name<>'..')
      THEN auflisten(verzeichnis+SuchRecord.name,liste)
      // ansonsten Datei zur Liste hinzufgen
      ELSE IF (SuchRecord.Name<>'.') and (SuchRecord.Name<>'..')
           THEN Liste.Add(Verzeichnis+SuchRecord.Name);
    END;
  // finden abschlieen
//  FindClose(SuchRecord);

end; //of auflisten

// ______________________________________________________________________________________________

procedure DateiKopieren(von,nach:string);
var
  FromF, ToF: file;
  NumRead, NumWritten: Integer;
  Buf: array[1..65536] of Char;
begin
    filemode:=0;
    forcedirectories(extractfilepath(nach));
    AssignFile(FromF, von);
    Reset(FromF, 1);	   { Datensatzgre = 1 }
    AssignFile(ToF, nach); { Ausgabedatei ffnen }
    Rewrite(ToF, 1);	   { Datensatzgre = 1 }
    repeat
      BlockRead(FromF, Buf, SizeOf(Buf), NumRead);
      BlockWrite(ToF, Buf, NumRead, NumWritten);
      application.processmessages;
    until (NumRead = 0) or (NumWritten <> NumRead);
    CloseFile(FromF);
    CloseFile(ToF);
end;

// ______________________________________________________________________________________________


function shorten(var lang:string):string;
begin
  IF length(lang)>250 THEN
  BEGIN
    result:=copy(lang,1,250);
    delete(lang,1,250)
  END ELSE
  BEGIN
    result:=(lang);
    lang:='';
  END;
end;

// ______________________________________________________________________________________________

procedure killspace(var s:string);
begin
  WHILE (copy(s,1,4)='<LF>') OR (copy(s,1,4)='<CR>') DO delete(s,1,4);
  WHILE copy(s,1,1)=' ' DO delete(s,1,1);
  WHILE (copy(s,1,1)=#10) OR (copy(s,1,1)=#13) DO delete(s,1,1);
end;

// ______________________________________________________________________________________________

function Recno(oTable: TTable): Longint;
var
  rslt: DBIResult;
  rRecordProp: RECProps;
  szErrMsg: DBIMSG;

begin
  Result := 0;
  try
    oTable.UpdateCursorPos;
    rslt:= DbiGetRecord( oTable.Handle, dbiNOLOCK, nil, @rRecordProp);
    IF rslt = DBIERR_NONE THEN
      Result := rRecordProp.iPhyRecNum
    ELSE
      CASE rslt of
        DBIERR_BOF: Result := 1;
        DBIERR_EOF: Result := oTable.RecordCount;
        ELSE
        begin
          DbiGetErrorString(rslt, szErrMsg);
          ShowMessage(StrPas(szErrMsg));
        end;
      END
  except
    on E: EDBEngineError do ShowMessage(E.Message);
  end;
end;

// ______________________________________________________________________________________________

function WINloeschen(Datei:String):boolean;
var Operation : TSHFileOpStruct;
begin
  WITH operation DO
    BEGIN
      wnd:=Application.Handle;
      wFunc:=FO_DELETE;
      lpszProgressTitle:='Deleting...';
      pFrom:=PChar(Datei);
      pTo:=PChar(Datei);
      fFlags:=FOF_AllowUndo;
    END;
    IF SHFileOperation(Operation)=0 THEN result:=true ELSE result:=false;
end;

// ______________________________________________________________________________________________

function WINbewegen(von,nach:string):boolean;
var Operation : TSHFileOpStruct;
begin
  WITH operation DO
  BEGIN
    wnd:=Application.Handle;
    wFunc:=FO_MOVE;
    lpszProgressTitle:='Moving...';
    pFrom:=PChar(von);
    pTo:=PChar(nach);
    fFlags:=FOF_AllowUndo;
  END;
  IF SHFileOperation(Operation)=0 THEN result:=true ELSE result:=false;
end;


begin
end.