program BotMaker;

uses
  Forms, SysUtils, classes;

{$R *.RES}

var Xliste,Yliste:tstringlist;

function Model(path:string):string;
begin
  result:=path;
  IF result[length(result)]='\' THEN delete(result,length(result),1);
  WHILE pos('\',result)<>0 DO delete(result,1,1);
end;


function zufallswerte:string;
begin
  result:=INTtoSTR(random(3)+2)+' '+          //Firing Accuracy
          INTtoSTR(random(3)+2)+' '+          //Aggressiveness
          INTtoSTR(random(3)+2)+' '+          //Combat Skill
          INTtoSTR(random(8)+1)+' '+          //prefered Weapon
          INTtoSTR(random(400));              //Ping
end;

procedure getIt(verzeichnis:string; var liste:tstringlist);
var
  SR:TSearchRec;
   x:integer;
begin
  IF verzeichnis[length(verzeichnis)]<>'\' THEN verzeichnis:=verzeichnis+'\';
  x:=FindFirst(verzeichnis+'*.*', $3F, SR);
  WHILE x=0 DO
  BEGIN
    IF ((SR.Attr AND faDirectory)>0) AND (SR.Name<>'.') AND (SR.name<>'..')
    THEN getIT(verzeichnis+SR.name,liste)
    ELSE IF (SR.Name<>'.') AND (SR.name<>'..')
             AND (lowercase(copy(SR.name,length(SR.name)-3,4))='.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-5,2))<>'_i')
             AND (lowercase(copy(SR.name,length(SR.name)-9,10))<>'weapon.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-8,9))<>'w_bfg.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-15,14))<>'w_chaingun.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-16,15))<>'w_glauncher.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-19,18))<>'w_hyperblaster.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-17,16))<>'w_machinegun.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-14,13))<>'w_railgun.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-16,15))<>'w_rlauncher.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-14,13))<>'w_shotgun.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-15,14))<>'w_sshotgun.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-14,13))<>'w_blaster.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-8,9))<>'ctf_r.pcx')
             AND (lowercase(copy(SR.name,length(SR.name)-8,9))<>'ctf_b.pcx')
         THEN
           liste.add('"'+
                     copy(SR.name,1,length(SR.name)-4)+
                     '" "'+
                     Model(verzeichnis)+
                     '/'+
                     copy(SR.name,1,length(SR.name)-4)+
                     '" '+
                     zufallswerte);
    x:=FindNext(SR);
  END;
  FindClose(SR);
end;

procedure getVWEP(verzeichnis:string; var liste:tstringlist);
var
  SR:TSearchRec;
   x:integer;
   
begin
  IF verzeichnis[length(verzeichnis)]<>'\' THEN verzeichnis:=verzeichnis+'\';
  x:=FindFirst(verzeichnis+'*.*', $3F, SR);
  WHILE x=0 DO
  BEGIN
    IF ((SR.Attr AND faDirectory)>0) AND (SR.Name<>'.') AND (SR.name<>'..')
    THEN getVWEP(verzeichnis+SR.name,liste)
    ELSE IF (lowercase(SR.Name)='w_bfg.md2')
         THEN liste.add('"'+Model(verzeichnis)+'"');
    x:=FindNext(SR);
  END;
  FindClose(SR);
end;

begin
  Application.Initialize;
  Application.Title := 'Eraser BotMaker';
  Application.Run;
  randomize;
  IF paramcount<1 THEN
  BEGIN
    writeln('You must give your Players-Directory as Parameter!');
    writeln;
    writeln('e.g.:  BotMaker.exe c:\quake2\baseq2\players\');
  END
  ELSE
  BEGIN

  Xliste:=tstringlist.create;
  Xliste.add('[bots]');
  Yliste:=tstringlist.create;
  Yliste.add('[view weapons]');

  writeln('Creating Bots...');
  getIt(paramStr(1),Xliste);
  writeln(Xliste.count-1,' Bots created!');
  writeln('Checking VWep...');
  getVWEP(paramStr(1),Yliste);
  writeln(Yliste.count-1,' Models with VWep-Support detected!');

  Xliste.AddStrings(yliste);

  Xliste.SaveToFile(extractfilepath(application.exename)+'bots.cfg');
  Yliste.free;
  Xliste.free;

  END;
end.

