unit ExecUnit;

interface

uses
  SysUtils,WinTypes, ShellApi;

CONST
  ExecOk = 33;

VAR
  ExecResult : INTEGER;
  ExecLastProg : STRING;

FUNCTION Exec(Prog,Params,StartDir:STRING):INTEGER;
FUNCTION ExecResultMsg:STRING;

implementation


FUNCTION Exec(Prog,Params,StartDir:STRING):INTEGER;
(* Ausfhren eines Dos-Programmes. z.B. 'PLZ.EXE','','G:\PLZ' *)
(* Groer Bildschirm *)
BEGIN
  TRY
  RESULT := ShellExecute(0{handle},
                         nil,
                         PChar(Prog),
                         PChar(Params),
                         PChar(StartDir),
                         SW_SHOWNORMAL
//                         SW_SHOWMaximized
                         );
  FINALLY
  ExecResult := RESULT;
  ExecLastProg := Prog;
  END;
END;


FUNCTION ExecResultMsg:STRING;
BEGIN
  IF ExecResult >= ExecOk
    THEN Result := ''
    ELSE
      BEGIN
        Result := '[' + IntToStr(ExecResult) + '] ';
        CASE ExecResult OF
        0 : Result := Result + 'Zuwenig Speicher, ausfhrbare Datei war zerstrt, Relokationswerte waren ungltig';
        2 : Result := Result + '(Programm-)Datei '+#13#10+ExecLastProg+#13#10+'wurde nicht gefunden.';
        3 : Result := Result + 'Verzeichnis wurde nicht gefunden.';
        5 : Result := Result + 'Fehler beim gemeinsamen Zugriff auf eine Datei im Netz oder Fehler'+
                        ' beim Zugriff auf eine gesperrte Datei im Netz.';
        6 : Result := Result + 'Bibliothek forderte separate Datensegmente fr jede Task an.';
        8 : Result := Result + 'Zuwenig Speicher, um die Anwendung zu starten.';
        10: Result := Result + 'Falsche Windows-Version.';
        11: Result := Result + 'Ungltige ausfhrbare Datei. Entweder keine Windows-Anwendung oder Fehler in der EXE-Datei.';
        12: Result := Result + 'Anwendung fr ein anderes Betriebssystem.';
        13: Result := Result + 'Anwendung fr MS-DOS 4.0.';
        14: Result := Result + 'Typ der ausfhrbaren Datei unbekannt.';
        15: Result := Result + 'Versuch, eine Real-Mode-Anwendung (fr eine frhere Windows-Version) zu laden.';
        16: Result := Result + 'Versuch, eine zweite Instanz einer ausfhrbaren Datei mit mehreren Datensegmenten'+
                 ', die nicht als nur lesbar gekennzeichnet waren, zu laden.';
        19: Result := Result + 'Versuch, eine komprimierte ausfhrbare Datei zu laden. Die Datei mu dekomprimiert'+
                 ' werden, bevor sie geladen werden kann.';
        20: Result := Result + 'Ungltige dynamische Linkbibliothek (DLL). Eine der DLLs, die bentigt wurde, um '+
                  'die Anwendung auszufhren, war beschdigt.';
      END; (*CASE *)
  END; (* ELSE *)
END;  (* ExecResultMsg *)


BEGIN
  ExecResult := ExecOk;
end.



Fenstertypen:
        0 : typ:=SW_HIDE;
        1 : typ:=SW_MINIMIZE;
        2 : typ:=SW_RESTORE;
        3 : typ:=SW_SHOW;
        4 : typ:=SW_SHOWMAXIMIZED;
        5 : typ:=SW_SHOWMINIMIZED;
        6 : typ:=SW_SHOWMINNOACTIVE;
        7 : typ:=SW_SHOWNA;
        8 : typ:=SW_SHOWNOACTIVATE;
        9 : typ:=SW_SHOWNORMAL;



Errors:

