unit bsp;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Buttons, Grids, Db, DBTables, main;

var liste1,liste2,liste3:tstringlist;                                           //fr bergabe der daten

procedure listit(source:string; var list1,list2,list3:tstringlist);             //bsp, level, source
procedure auflisten(verzeichnis:string);
function itemscan(source:string; leveldateiname:string):string;

implementation
  

procedure listit(source:string; var list1,list2,list3:tstringlist);
var
               ent: CHAR;                                       //Buffer zum auslesen der Entitys
               buf: ARRAY [1..8] of byte;                       //Buffer zum lesen des EntityOffsets
               ofs: ARRAY [1..8] of byte;                       //Buffer zum lesen des BSP-Offsets
            datbuf: ARRAY [1..56] of char;                      //Buffer zum lesen der BSP-Definitions
                 f:file;                                        //Dateivariable
             entOS: longint;                                    //Entity Offset
             entSZ: longint;                                    //Entity Lnge
            offset: longint;                                    //Offset wo die Maps stehen
         BSPoffset: longint;                                    //BSP-Offset
           BSPsize: longint;                                    //BSP-Grsse
            deflen: longint;                                    //Lnge der Angaben von Maps
            enddef: longint;
                 i: integer;                                    //indexvariable
                 x: string;                                     //hilfsvariable
          BSPdatei: string;                                     //Name der BSP-Datei

function NamePart(FileName: string): string;
begin
  result:=FileName;
  WHILE pos('\',result)<>0 DO delete(result,1,1);
end;

begin
  filemode:=0;
  assignfile(f,source);
  reset(f,1);

  form1.statusbar2.panels[0].text:=source;
  form1.statusbar2.Repaint;

  IF lowercase(copy(source,length(source)-3,4))='.bsp' THEN
  BEGIN
// Arbeitssschritte fr Leveldateien

  seek(f,8);                                                    //IBSP und version berspringen

  blockread(f,Buf,8);                                           //EntityOffset lesen
  entOS:= buf[1]*1                                              //EntityOffset berechnen
         +buf[2]*256
         +buf[3]*65536
         +buf[4]*16777216;
  entSZ:= buf[5]*1                                              //EntitySize berechnen
         +buf[6]*256
         +buf[7]*65536
         +buf[8]*16777216;

  IF entOS+entSZ<=filesize(f) THEN seek(f,entOS) ELSE exit;                                                //Zu den Entitys springen

  WHILE filepos(f)<entOS+entSZ DO                              //lesen der EntityDefinitionen
  BEGIN
    BlockRead(f, ent, 1);
    IF ent =#123 THEN                                           //wenn { zusammensetzen bis
      WHILE ent<>#125 DO                                        // }
      BEGIN
        x:=x+ent;
        IF not eof(f) THEN BlockRead(f, ent, 1) ELSE break;
      END;
    IF pos('worldspawn',x)<>0 THEN break ELSE x:='';            //wenn worldspawn dann break
  END;

  i:=pos('"message"',lowercase(x));

  IF i=0 THEN x:=''                                            //berprfen ob Level einen Namen hat
         ELSE
           IF x<>'' THEN
           BEGIN                                                //string zurechtstutzen
             delete(x,1,i+8);
             i:=pos('"',x);
             delete(x,1,i);
             i:=pos('"',x);
             x:=copy(x,1,i-1);
             x:=x;
           END;

  list1.add(copy(namepart(source),1,length(namepart(source))-4));
  list2.add(x);
  list3.add(source);

// Arbeitsschritte fr Leveldateien beendet
  END
  ELSE IF lowercase(copy(source,length(source)-3,4))='.pak' THEN
  BEGIN
// Arbeitsschritte fr PAK-Dateien

  seek(f,4);             // die ersten 4 bytes ueberspringen (PACK)
  blockread(f,buf,8);    // die nchsten 8 byte geben die positon und laenge der dateinamen an
  offset:= buf[1]*1      // bytes addieren (rueckwrts)
          +buf[2]*256
          +buf[3]*65536
          +buf[4]*16777216;
  deflen:= buf[5]*1      // bytes addieren (rueckwrts)
          +buf[6]*256
          +buf[7]*65536
          +buf[8]*16777216;

  enddef:=offset+deflen;

  IF enddef>filesize(f) THEN exit;

  WHILE NOT eof(f) DO
  BEGIN
  application.processmessages;
  seek(f,offset);                                                               //zur Startpostion springen
  IF filepos(f)>=enddef THEN BREAK;

  blockread(f,datbuf,56);                                                       //Dateiname lesen

  FOR i:=1 TO 56 DO                                                             //chars zusammenfassen
    IF datbuf[i] IN ['a'..'z','A'..'Z','0'..'9','/','\','_','-','.']
      THEN BSPdatei:=BSPdatei+datbuf[i]
      ELSE break;

  IF lowercase(copy(BSPdatei,length(BSPdatei)-3,4))<>'.bsp' THEN BSPdatei:='';  //auf .bsp-Endung prfen
  WHILE pos('/',BSPdatei)<>0 DO delete(BSPdatei,1,1);                           //Verzeichnis entfernen

  blockread(f,ofs,8);                                                           //Offsetdaten lesen (8byte wegen size)

  Offset:=filepos(f);                                                           //aktuelle position als offset merken

  IF BSPdatei<>'' THEN                                                          //Wenn BSP-Definition
  BEGIN
    BSPoffset:= ofs[1]*1                                                        //BSPoffset errechnen
               +ofs[2]*256
               +ofs[3]*65536
               +ofs[4]*16777216;
    BSPsize  := ofs[5]*1                                                        //BSPsize errechnen
               +ofs[6]*256
               +ofs[7]*65536
               +ofs[8]*16777216;

  IF BSPsize<100000 THEN break;                                                 //unechte Levels raus

  IF BSPoffset<filesize(f) THEN seek(f,BSPoffset+8) ELSE exit;                                          //IBSP und version berspringen
  application.processmessages;

  blockread(f,Buf,8);                                           //EntityOffset lesen
  entOS:= buf[1]*1                                              //EntityOffset berechnen
         +buf[2]*256
         +buf[3]*65536
         +buf[4]*16777216;
  entSZ:= buf[5]*1                                              //EntitySize berechnen
         +buf[6]*256
         +buf[7]*65536
         +buf[8]*16777216;
  entOS:=BSPoffset+entOS;                                       //Offsets relativ zum Startoffset

  IF entOS+entSZ<=filesize(f) THEN seek(f,entOS) ELSE exit;                                                //Zu den Entitys springen

  WHILE filepos(f)<entOS+entSZ DO                              //lesen der EntityDefinitionen
  BEGIN
    BlockRead(f, ent, 1);
    IF ent =#123 THEN                                           //wenn { zusammensetzen bis
      WHILE ent<>#125 DO                                        // }
      BEGIN
        x:=x+ent;
        IF NOT eof(f) THEN BlockRead(f, ent, 1) ELSE break;
      END;
    IF pos('worldspawn',x)<>0 THEN break ELSE x:='';            //wenn worldspawn dann break
  END;

  i:=pos('"message"',lowercase(x));

  IF i=0 THEN x:=''                                             //berprfen ob Level einen Namen hat
         ELSE
           IF x<>'' THEN
           BEGIN                                                //string zurechtstutzen
             delete(x,1,i+8);
             i:=pos('"',x);
             delete(x,1,i);
             i:=pos('"',x);
             x:=copy(x,1,i-1);
             x:=x;
           END;

  // x enthaelt den Levelnamen
  list1.add(copy(BSPdatei,1,length(BSPdatei)-4));
  list2.add(x);
  list3.add(source);
  END;
  End;

// ENde der PAK-Anweisungen
  END;
  form1.statusbar2.panels[0].text:='';
  form1.statusbar2.Repaint;
  close(f);
end;


///////////////////////////////////////////////////////////////////////////////////////////////////////

procedure auflisten(verzeichnis:string);
var suchRecord: TsearchRec;


begin


  // wenn das Backslash am Ende fehlt: hinzufgen
  if Verzeichnis[length(Verzeichnis)]<>'\' then Verzeichnis:=Verzeichnis+'\';

  // erstes finden (alle Dateien: $3F)
  if FindFirst(Verzeichnis+'*.*',$3F,SuchRecord)=0 then
    BEGIN
      // falls Verzeichnis: Rekursion
      IF ((SuchRecord.Attr AND faDirectory)>0)
         AND (SuchRecord.Name<>'.')
         AND (SuchRecord.Name<>'..')
      THEN auflisten(verzeichnis+SuchRecord.name)
      // ansonsten Datei zur Liste hinzufgen
      ELSE IF (SuchRecord.Name<>'.') and (SuchRecord.Name<>'..')
           THEN
           IF (copy(lowercase(SuchRecord.Name),length(SuchRecord.Name)-3,4)='.pak')
           OR (copy(lowercase(SuchRecord.Name),length(SuchRecord.Name)-3,4)='.bsp')
           THEN
           BEGIN
             listit(verzeichnis+SuchRecord.name,liste1,liste2,liste3);
           END;
    END;

  // weitere finden
  WHILE FindNext(SuchRecord)=0 DO
    BEGIN
      // falls Verzeichnis: Rekursion
      IF ((SuchRecord.Attr AND faDirectory)>0)
         AND (SuchRecord.Name<>'.')
         AND (SuchRecord.Name<>'..')
      THEN auflisten(verzeichnis+SuchRecord.name)
      // ansonsten Datei zur Liste hinzufgen
      ELSE IF (SuchRecord.Name<>'.') and (SuchRecord.Name<>'..')
           THEN
           IF (copy(lowercase(SuchRecord.Name),length(SuchRecord.Name)-3,4)='.pak')
           OR (copy(lowercase(SuchRecord.Name),length(SuchRecord.Name)-3,4)='.bsp')
           THEN
           BEGIN
             listit(verzeichnis+SuchRecord.name,liste1,liste2,liste3);
           END;
      application.processmessages;
    END;
  // finden abschlieen
  FindClose(SuchRecord);

end;
///////////////////////////////////////////////////////////////////////////////////////////////////////

function itemscan(source:string; leveldateiname:string):string;
var GL, RL, HB, RG, BFG, QUAD, INV :boolean;
               ent: CHAR;                                       //Buffer zum auslesen der Entitys
               buf: ARRAY [1..8] of byte;                       //Buffer zum lesen des EntityOffsets
               ofs: ARRAY [1..8] of byte;                       //Buffer zum lesen des BSP-Offsets
            datbuf: ARRAY [1..56] of char;                      //Buffer zum lesen der BSP-Definitions
                 f:file;                                        //Dateivariable
             entOS: longint;                                    //Entity Offset
             entSZ: longint;                                    //Entity Lnge
            offset: longint;                                    //Offset wo die Maps stehen
         BSPoffset: longint;                                    //BSP-Offset
            deflen: longint;                                    //Lnge der Angaben von Maps
            enddef: longint;
                 i: integer;                                    //indexvariable
                 x: string;                                     //hilfsvariable
          BSPdatei: string;                                     //Name der BSP-Datei
                PL: integer;                                    //Anzahl der Deathmatchstarts


begin
  screen.Cursor:=crHourGlass;

  PL:=0;
  GL:=false;
  RL:=false;
  HB:=false;
  RG:=false;
  BFG:=false;
  QUAD:=false;
  INV:=false;

  filemode:=0;
  assignfile(f,source);                                         //Datei ffnen
  reset(f,1);

  IF lowercase(copy(source,length(source)-3,4))='.bsp' THEN
  BEGIN
    // Arbeitssschritte fr Leveldateien

    seek(f,8);                                                    //IBSP und version berspringen

    blockread(f,Buf,8);                                           //EntityOffset lesen
    entOS:= buf[1]*1                                              //EntityOffset berechnen
           +buf[2]*256
           +buf[3]*65536
           +buf[4]*16777216;
    entSZ:= buf[5]*1                                              //EntitySize berechnen
           +buf[6]*256
           +buf[7]*65536
           +buf[8]*16777216;

    IF entOS+entSZ<=filesize(f) THEN seek(f,entOS) ELSE exit;                                                //Zu den Entitys springen

    WHILE filepos(f)<entOS+entSZ DO                              //lesen der EntityDefinitionen
    BEGIN
      BlockRead(f, ent, 1);
      IF ent =#123 THEN                                           //wenn { zusammensetzen bis
        WHILE ent<>#125 DO                                        // }
        BEGIN
          x:=x+ent;
          BlockRead(f, ent, 1);
        END;
      IF pos('weapon_grenadelauncher',x)<>0 THEN GL:=true;
      IF pos('weapon_rocketlauncher',x)<>0  THEN RL:=true;
      IF pos('weapon_hyperblaster',x)<>0    THEN HB:=true;
      IF pos('weapon_railgun',x)<>0         THEN RG:=true;
      IF pos('weapon_bfg',x)<>0             THEN BFG:=true;
      IF pos('item_quad',x)<>0              THEN QUAD:=true;
      IF pos('item_invulnerability',x)<>0   THEN INV:=true;
      IF pos('info_player_deathmatch',x)<>0 THEN inc(PL);
      x:='';
      // IF GL AND RL AND HB AND RG AND BFG AND QUAD AND INV THEN break;
    END;
  END
  ELSE IF lowercase(copy(source,length(source)-3,4))='.pak' THEN
  BEGIN
    // Arbeitsschritte fr PAK-Dateien

    seek(f,4);             // die ersten 4 bytes ueberspringen (PACK)
    blockread(f,buf,8);    // die nchsten 8 byte geben die positon und laenge der dateinamen an
    offset:= buf[1]*1      // bytes addieren (rueckwrts)
            +buf[2]*256
            +buf[3]*65536
            +buf[4]*16777216;
    deflen:= buf[5]*1      // bytes addieren (rueckwrts)
            +buf[6]*256
            +buf[7]*65536
            +buf[8]*16777216;
    enddef:=offset+deflen;

    IF enddef<=filesize(f) THEN seek(f,offset) ELSE exit;                                                          //zur Startpostion springen
    application.processmessages;

    WHILE NOT eof(f) DO
    BEGIN

      IF filepos(f)>=enddef THEN BREAK;

      blockread(f,datbuf,56);

      FOR i:=1 TO 56 DO                                                             //chars zusammenfassen
        IF datbuf[i] IN ['a'..'z','A'..'Z','0'..'9','/','\','_','-','.']
          THEN BSPdatei:=BSPdatei+datbuf[i]
          ELSE break;

      IF lowercase(copy(BSPdatei,length(BSPdatei)-3,4))<>'.bsp' THEN BSPdatei:='';  //auf .bsp-Endung prfen
      WHILE pos('/',BSPdatei)<>0 DO delete(BSPdatei,1,1);                           //Verzeichnis entfernen

      blockread(f,ofs,8);                                                           //Offsetdaten lesen (8byte wegen size)

      IF lowercase(BSPdatei)=lowercase(leveldateiname+'.bsp') THEN break;
    END;

        IF BSPdatei<>'' THEN                                                          //Wenn BSP-Definition
        BEGIN
          BSPoffset:= ofs[1]*1                                                        //BSPoffset errechnen
                     +ofs[2]*256
                     +ofs[3]*65536
                     +ofs[4]*16777216;

          IF BSPoffset<filesize(f) THEN seek(f,BSPoffset+8) ELSE exit;                                          //IBSP und version berspringen

          blockread(f,Buf,8);                                           //EntityOffset lesen
          entOS:= buf[1]*1                                              //EntityOffset berechnen
               +buf[2]*256
               +buf[3]*65536
               +buf[4]*16777216;
          entSZ:= buf[5]*1                                              //EntitySize berechnen
               +buf[6]*256
               +buf[7]*65536
               +buf[8]*16777216;
          entOS:=BSPoffset+entOS;                                       //Offsets relativ zum Startoffset
//          entSZ:=BSPoffset+entSZ;

          seek(f,entOS);                                                //Zu den Entitys springen

          WHILE filepos(f)<entOS+entSZ DO                              //lesen der EntityDefinitionen
          BEGIN
            BlockRead(f, ent, 1);
            IF ent =#123 THEN                                           //wenn { zusammensetzen bis
              WHILE ent<>#125 DO                                        // }
              BEGIN
                x:=x+ent;
                BlockRead(f, ent, 1);
              END;
            IF pos('weapon_grenadelauncher',x)<>0 THEN GL:=true;
            IF pos('weapon_rocketlauncher',x)<>0  THEN RL:=true;
            IF pos('weapon_hyperblaster',x)<>0    THEN HB:=true;
            IF pos('weapon_railgun',x)<>0         THEN RG:=true;
            IF pos('weapon_bfg',x)<>0             THEN BFG:=true;
            IF pos('item_quad',x)<>0              THEN QUAD:=true;
            IF pos('item_invulnerability',x)<>0   THEN INV:=true;
            IF pos('info_player_deathmatch',x)<>0 THEN inc(PL);
            x:='';
            //IF GL AND RL AND HB AND RG AND BFG AND QUAD AND INV THEN break;
          END;
        END;


  END;
  result:=INTtoSTR(PL)+',';
  IF GL   THEN result:=result+'"GL"';
  IF RL   THEN result:=result+'"RL"';
  IF HB   THEN result:=result+'"HB"';
  IF RG   THEN result:=result+'"RG"';
  IF BFG  THEN result:=result+'"BFG"';
  IF QUAD THEN result:=result+'"QUAD"';
  IF INV  THEN result:=result+'"INV"';
  closefile(f);                                                  //Datei schlieen
  screen.cursor:=crDefault;
end;

///////////////////////////////////////////////////////////////////////////////////////////////////////

begin

  liste1:=tstringlist.create;
  liste2:=tstringlist.create;
  liste3:=tstringlist.create;

end.


