unit commandline;

interface

function dmflags:integer; //berechnet die deathmatchflagangaben
procedure starten(startcode:byte;botnum:integer); //Startet Programme

implementation
uses main, sysutils, andi, WinTypes, ShellApi, Dialogs, execUnit, cmdEdit, controls;


function dmflags:integer;
begin
  result:=0;
  IF form1.checkbox1.Checked THEN result:=result+1;
  IF form1.checkbox2.Checked THEN result:=result+2;
  IF form1.checkbox3.Checked THEN result:=result+4;
  IF form1.checkbox4.Checked THEN result:=result+8;
  IF form1.checkbox5.Checked THEN result:=result+16;
  IF form1.checkbox6.Checked THEN result:=result+32;
  IF form1.checkbox7.Checked THEN result:=result+64;
  IF form1.checkbox8.Checked THEN result:=result+128;
  IF form1.checkbox9.Checked THEN result:=result+256;
  IF form1.checkbox10.Checked THEN result:=result+512;
  IF form1.checkbox11.Checked THEN result:=result+1024;
  IF form1.checkbox12.Checked THEN result:=result+2048;
  IF form1.checkbox13.Checked THEN result:=result+4096;
  IF form1.checkbox14.Checked THEN result:=result+8192;
  IF form1.checkbox15.Checked THEN result:=result+16384;
  IF form1.checkbox16.Checked THEN result:=result+32768;
  IF form1.checkbox17.Checked THEN result:=result+65536;
  IF form1.checkbox18.Checked THEN result:=result+131072;
  IF form1.checkbox19.Checked THEN result:=result+262144;
end;

function getmodinfo(game:string):string;
var i:byte;
begin
  result:='';
  FOR i:=1 TO 10 DO
  WITH form1.StringGrid1 DO
  BEGIN
    IF lowercase(cells[0,i])= lowercase(game)
      THEN result:=cells[1,i];
  END;
  IF result='' THEN
    IF messagedlg('Mod not found!'+#10+#13+
                  'Make sure that it is entered correctly in the Mods-Section!'
                  +#10+#13+#10+#13+
                  'Should I start normal Quake now?',mtError,[mbYes,mbNo],0)<>mrYes
    THEN abort;
end;

function params(game:string;botnum:byte):string;                     //setzt die parameter zusammen
var dummy: string;
begin
  dummy:=dummy+' +set deathmatch 1';                    //deathmatch variable



  IF game ='ERASER' THEN
                      dummy:=dummy+' +set game eraser +set bot_num '+INTtoSTR(botnum) // Eraser
                    ELSE
  IF game ='DM' THEN
                  dummy:=dummy                                             //Standardquake
                ELSE
  IF game ='CTF' THEN
                  dummy:=dummy+' +set game ctf'                            //CTF
                ELSE
                  dummy:=dummy+' '+getmodinfo(game);                       //MOD

  dummy:=dummy+' +set timelimit '+FLOATtoSTR(form1.RxSpinEdit1.Value);     //timelimit
  dummy:=dummy+' +set fraglimit '+FLOATtoSTR(form1.RxSpinEdit2.Value);     //fraglimit
  dummy:=dummy+' +set capturelimit '+FLOATtoSTR(form1.RxSpinEdit3.Value);  //capturelimit
  dummy:=dummy+' +set dmflags '+form1.dmflaglabel.caption;                 //dmflags
  dummy:=dummy+' '+form1.edit3.Text;                                       //zustzliche Parameter


  dummy:=dummy+' +map '+form1.DBEdit1.Text;             //Level

  IF form1.checkbox20.checked THEN
  BEGIN
    CMDLdialog.edit1.text:=dummy;                        //ffnet den Parametereditdialog
    IF CMDLdialog.showmodal<>mrOK THEN abort;
    dummy:=CMDLdialog.edit1.text;
  END;

  IF copy(dummy,1,1)<>' ' THEN dummy:=' '+dummy;         //stellt sicher, dass ein leerzeichen vor den parametern kommt
  
  result:=dummy;
end;

function botnumcalc:byte;                               //berechnet die Botanzahl
begin
  WITH form1 DO
  BEGIN
  IF STRtoINT(dbedit4.text)<STRtoINT(dbedit3.text)
    THEN
    BEGIN
      MessageDlg('Playernumbers are unlogical!', mtError,[mbOk], 0);
      result:=0;
    END
    ELSE
    BEGIN
    //botnum = minPlayer + (( maxPlayer-minPlayer) durch 2 ) -1
    result:=STRtoINT(dbedit3.text)+((STRtoINT(dbedit4.text)-STRtoINT(dbedit3.text)) div 2)-1;
    IF (form1.rxdbcombobox1.text='CTF') AND (result mod 2 <>0) THEN result:=result-1;
    END;
  END;
end;

procedure starten(startcode:byte;botnum:integer);
begin
  CASE startcode OF
  1: Exec(extractfilename(form1.filenameedit1.filename),   //Quake
          params(form1.RXDBcomboBox1.Text,0),
          extractfilepath(form1.filenameedit1.filename));

  2: Exec(extractfilename(form1.filenameedit1.filename),   //Eraser
          params('ERASER',botnumcalc),
          extractfilepath(form1.filenameedit1.filename));

  3: Exec(extractfilename(form1.filenameedit1.filename),   //Eraser mit
          params('ERASER',botnum),                         //selbstdefinierter
          extractfilepath(form1.filenameedit1.filename));  //Botnum

  4: Exec(extractfilename(form1.filenameedit1.filename),   //quake mit mod
          params(form1.stringgrid1.cells[0,botnum],0),     //das ber Popup
          extractfilepath(form1.filenameedit1.filename));  //gewaehlt wurde
  END;
end;



end.

