unit druck;

interface

procedure drucken;                              //ruft den Druckdialog auf
procedure Listedrucken;                         //druckt die levelliste


implementation
uses main, printers, andi, graphics, sysutils, printdlg, classes, windows;

procedure Listedrucken;
var druckline,weaps:string;
    i,y:integer;
begin

WITH form1 DO
BEGIN

//  if printdialog1.Execute then
//  BEGIN
    Printer.title:='QLIFF Printjob';
    printer.begindoc;
    printer.Canvas.Font.size:=10;
    printer.canvas.font.name:='MS Sans Serif';
    printer.canvas.font.pitch:=fpFixed;

    WITH Datasource1.Dataset DO
    BEGIN
      disablecontrols;
      druckline:=       cutS('No.',3)
                  +' '+ cutS('File',11)
                  +' '+ cutS('Level',30)
                  +' '+ cutS('Type',8)
                  +' '+ cutS('Player',7)
                  +' '+ cutS('Rate',4)
                  +' Items';
      printer.Canvas.Font.Style:=[fsBold];
      printer.canvas.textout(50,50,druckline);
      printer.Canvas.Font.Style:=[];

      first; // erste Zeile
      y:=0;
      i:=printer.canvas.TextHeight('X');
      WHILE NOT eof DO
      begin
        weaps:='';
        y:=y+1;
        IF (fields[8].value) THEN weaps:=weaps+'GL ' ELSE weaps:=weaps+'   ';
        IF (fields[9].value) THEN weaps:=weaps+'RL ' ELSE weaps:=weaps+'   ';
        IF (fields[10].value) THEN weaps:=weaps+'HB ' ELSE weaps:=weaps+'   ';
        IF (fields[11].value) THEN weaps:=weaps+'RG ' ELSE weaps:=weaps+'   ';
        IF (fields[12].value) THEN weaps:=weaps+'BFG ' ELSE weaps:=weaps+'    ';
        IF (fields[6].value) THEN weaps:=weaps+'Quad ' ELSE weaps:=weaps+'     ';
        IF (fields[7].value) THEN weaps:=weaps+'Invul ' ELSE weaps:=weaps+'      ';
        druckline:=      cutS(INTtoSTR(y),3)
                   +' '+ cutS(fields[0].asstring,11)
                   +' '+ cutS(fields[1].asstring,30)
                   +' '+ cutS(fields[2].asstring,8)
                   +' '+ cutS(fields[3].asstring+'-'+fields[4].asstring,7)
                   +' '+ cutS(fields[13].asstring+'%',4)
                   +' '+ weaps;
        printer.canvas.textout(50,50+i,druckline);
        i:=i+printer.canvas.textheight(druckline);
        IF i>= printer.PageHeight-100 THEN
        BEGIN
          printer.newpage;
          i:=0;
        END;
        NEXT; //naechste Zeile
      end;
    enablecontrols;
    END;
    printer.enddoc;
//  END;
end;
END;

procedure Detaildrucken(typ:byte);
var i,y,x:integer;
    lr,tr,tr2,rr,rr2:integer;
    r: trect;

begin
  Printer.title:='QLIFF Printjob';
  printer.begindoc;

  printer.canvas.font.Size:=12;
  printer.canvas.font.pitch:=fpFixed;
  printer.canvas.font.name:='Courier New';
  printer.Canvas.Font.Style:=[];

  lr:=printer.canvas.textwidth('aaaaa');
  rr:=printer.pagewidth-printer.canvas.textwidth('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa');
  rr2:=printer.pagewidth-printer.canvas.textwidth('aaaaaaaaaaaaaaaaaaaaa');
  tr:=printer.canvas.textheight('Xg')*2;
  tr2:=printer.canvas.textheight('Xg')*4;

  WITH form1.Datasource1.Dataset DO
  BEGIN
    disablecontrols;

    printer.canvas.font.pitch:=fpDefault;
    printer.canvas.font.name:='Arial';

    printer.Canvas.Font.size:=18;                         //LevelName
    printer.Canvas.Font.Style:=[fsBold];
    printer.canvas.textout(lr,tr,fields[1].asstring);

    printer.Canvas.Font.size:=15;                         //LevelDatei
    printer.Canvas.Font.Style:=[];
    printer.canvas.textout(lr,tr2,'['+fields[0].asstring+']');

    printer.canvas.font.Size:=12;
    printer.canvas.font.pitch:=fpFixed;
    printer.canvas.font.name:='Arial';
    printer.Canvas.Font.Style:=[fsBold];
    x:=printer.canvas.textheight('Xg');
    printer.canvas.textout(rr,tr2,'Players: ');
    printer.canvas.textout(rr,tr2+x,'Mod    : ');
    printer.canvas.textout(rr,tr2+x*2,'Rate   : ');
    printer.canvas.textout(rr,tr2+x*3,'Items  : ');

    printer.canvas.font.name:='Courier New';
    printer.Canvas.Font.Style:=[];
    printer.canvas.textout(rr2,tr2,fields[3].asstring+'-'+fields[4].asstring);
    printer.canvas.textout(rr2,tr2+x,fields[2].asstring);
    printer.canvas.textout(rr2,tr2+x*2,fields[13].asstring+'%');

    IF (fields[8].value)  THEN printer.canvas.font.color:=clBlack ELSE printer.canvas.font.color:=clGray;
    printer.canvas.textout(rr2,tr2+x*3,'Grenade Launcher');
    IF (fields[9].value)  THEN printer.canvas.font.color:=clBlack ELSE printer.canvas.font.color:=clGray;
    printer.canvas.textout(rr2,tr2+x*4,'Rocket Launcher');
    IF (fields[10].value) THEN printer.canvas.font.color:=clBlack ELSE printer.canvas.font.color:=clGray;
    printer.canvas.textout(rr2,tr2+x*5,'Hyperblaster');
    IF (fields[11].value) THEN printer.canvas.font.color:=clBlack ELSE printer.canvas.font.color:=clGray;
    printer.canvas.textout(rr2,tr2+x*6,'Railgun');
    IF (fields[12].value) THEN printer.canvas.font.color:=clBlack ELSE printer.canvas.font.color:=clGray;
    printer.canvas.textout(rr2,tr2+x*7,'BFG 10k');
    IF (fields[6].value)  THEN printer.canvas.font.color:=clBlack ELSE printer.canvas.font.color:=clGray;
    printer.canvas.textout(rr2,tr2+x*8,'Quad Damage');
    IF (fields[7].value)  THEN printer.canvas.font.color:=clBlack ELSE printer.canvas.font.color:=clGray;
    printer.canvas.textout(rr2,tr2+x*9,'Invulnerability');

    printer.canvas.font.color:=clBlack;
    printer.canvas.font.size:=10;
    form1.memo2.width:=385;
    form1.memo2.Text:=fields[5].asstring;
    y:=0;
    form1.Memo2.Visible:=true;
    FOR i:=0 TO form1.Memo2.lines.Count-1 DO
    BEGIN
      printer.canvas.textout(lr,tr2+x*3+y,form1.memo2.Lines[i]);
      y:=y+printer.canvas.textheight('Xg');
    END;
    form1.Memo2.Visible:=false;

    printer.canvas.textout(lr, printer.pageheight-x*2, 'printed by QLIFF 2 - visit http://www.planetquake.com/qliff');

    IF typ=4 THEN                                               //mit erstem Bild
    BEGIN
      form1.RxTimerEvent1.Enabled:=false;
      IF fileexists(verzeichnis+'\screens\'+fields[0].asstring+'.jpg') THEN
      BEGIN
        form1.image1.picture.loadfromfile(verzeichnis+'\screens\'+fields[0].asstring+'.jpg');
        R:= Rect(lr,tr*14,printer.pagewidth-lr
                  ,tr*14+round((printer.pagewidth-lr)*(3/4)));
        printer.Canvas.stretchdraw(R,form1.image1.picture.graphic);
      END;
      form1.RxTimerEvent1.Enabled:=true;
    END;

    enablecontrols;
  END;
  printer.enddoc;
end;



procedure drucken;
begin
  CASE printerdialog.execute OF
  1: Listedrucken;
  2: Detaildrucken(2);
  3: Detaildrucken(3);
  4: Detaildrucken(4);
  END;


end;

end.
