unit favouriten;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ComCtrls, StdCtrls, ExtCtrls, Placemnt;

type
  TForm4 = class(TForm)
    Panel1: TPanel;
    ListBox1: TListBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    FormPlacement1: TFormPlacement;
    procedure Favladen(Sender: TObject);
    procedure Favadd(Sender: TObject);
    procedure Favedit(Sender: TObject);
    procedure FavDel(Sender: TObject);
    procedure FavClose(Sender: TObject);
    procedure FavJump(Sender: TObject);
    procedure FavGo(Sender: TObject);

  private
    { Private-Deklarationen}
  public
    { Public-Deklarationen}

  end;
  procedure FavFuel;
  procedure Favspeichern;
var
  Form4: TForm4;

implementation
uses andi, favouritenEdit, Main, db, menus;


{$R *.DFM}

procedure Favspeichern;
begin
  form4.listbox1.Items.SaveToFile(verzeichnis+'favorites.ini');
end;

procedure TForm4.Favladen(Sender: TObject);
begin
  IF fileexists(verzeichnis+'favorites.ini') THEN
  listbox1.Items.LoadFromFile(verzeichnis+'favorites.ini');
end;

procedure FavFuel;
var NewItem:Tmenuitem;
          i:integer;
begin
  WHILE form1.m_favorites.Count>3 DO form1.m_favorites.Delete(3);

  FOR i:=0 TO form4.ListBox1.items.Count-1 DO
  BEGIN
    NewItem:=Tmenuitem.Create(form1.m_favorites);
    NewItem.caption:=form4.Listbox1.items[i];
    NewItem.hint:='Jumps to '+form4.Listbox1.items[i];
    NewItem.onClick:=form4.FavGo;
    form1.m_favorites.add(NewItem);
  END;
end;

procedure TForm4.Favadd(Sender: TObject);
begin
  favdesc:=form1.dbedit2.text;
  form5.showmodal;
  IF form5.modalresult=mrOK THEN
  BEGIN
    listbox1.Items.Add(form1.dbedit1.text+': '+favdesc);
  END;
  Favspeichern;
  Favfuel;
end;

procedure TForm4.Favedit(Sender: TObject);
begin
  IF listbox1.Items.Count=0 THEN exit;
  favdesc:=nachChar(listbox1.items[listbox1.itemindex],':');
  delete(favdesc,1,1);
  form5.showmodal;
  IF form5.modalresult=mrOK THEN
  BEGIN
    listbox1.Items[listbox1.itemindex]:=vorChar(listbox1.items[listbox1.itemindex],':')+
                                        ': '+favdesc;
  END;
  Favspeichern;
  Favfuel;
end;

procedure TForm4.FavDel(Sender: TObject);
begin
  listbox1.items.Delete(listbox1.itemindex);
  Favspeichern;
  Favfuel;
end;

procedure TForm4.FavClose(Sender: TObject);
begin
  close;
end;

procedure TForm4.FavJump(Sender: TObject);
begin
  form1.DataSource1.DataSet.Locate('Datei',
                                   vorChar(listbox1.items[listbox1.itemindex],':'),
                                   [loCaseInsensitive]);
end;

procedure TForm4.FavGo(Sender: TObject);
begin
  form1.DataSource1.DataSet.Locate('Datei',vorChar((sender as Tmenuitem).caption,':'),[loCaseInsensitive]);
end;

end.
