unit sync;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type
  TForm6 = class(TForm)
    Panel1: TPanel;
    Animate2: TAnimate;
    ProgressBar2: TProgressBar;
    Label23: TLabel;
    Button1: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private-Deklarationen}
  public
    { Public-Deklarationen}
  end;

var
  Form6: TForm6;

  continue:boolean;

procedure getQ2folder; //ruft browseforfolder auf;
procedure syncronisieren(typ:byte); //startet das syncroniesieren;
procedure markAll;

implementation

{$R *.DFM}
uses fileutil, main, andi;


function isQ2folder(folder:string):boolean;
begin
  IF folder='' THEN
               BEGIN
                 messagedlg('You have to select a foreign Folder!',mtError,[mbOK],0);
                 result:=false;
                 exit;
               END;
  IF NOT direxists(folder) THEN
               BEGIN
                 messagedlg('The selected Folder does not exist!',mtError,[mbOK],0);
                 result:=false;
                 exit;
               END;
  IF folder[length(folder)]<>'\' THEN folder:=folder+'\';
  IF fileexists(folder+'quake2.exe') THEN result:=true ELSE
    IF messagedlg('The selected Folder doesn''t seem to be a Quake 2 Folder!'+#10+#13+
               'Do you really want to continue?',mtConfirmation,[mbOK,mbCancel],0)=mrOK
      THEN result:=true ELSE result:=false;
end;

procedure getQ2folder;
var folder:string;
begin
  folder:=form1.Edit4.text;
  IF BrowseDirectory(folder, 'Select foreign Quake2-Folder',0) THEN
    form1.Edit4.text:=folder;
end;

procedure getPAKS(here,there:string; var liste:tstringlist);
var
  SR:TSearchRec;
   x:integer;
begin
    x:=FindFirst(here+'baseq2\*.pak', faAnyFile, SR);
    WHILE x=0 DO
    BEGIN
      IF NOT fileexists(there+'\baseq2\'+SR.name)
        THEN  liste.add(here+'\baseq2\'+SR.name+'@'+there+'\baseq2\'+SR.name);
      x:=FindNext(SR);
    END;
    FindClose(SR);
end;

procedure getIt(here,there,ext:string; var liste:tstringlist);
var
  SR:TSearchRec;
   x:integer;
begin
  IF here[length(here)]<>'\' THEN here:=here+'\';
  IF there[length(there)]<>'\' THEN there:=there+'\';

  x:=FindFirst(here+'*.*', $3F, SR);
  WHILE x=0 DO
  BEGIN
    IF ((SR.Attr AND faDirectory)>0) AND (SR.Name<>'.') AND (SR.name<>'..')
    THEN getIT(here+SR.name,there+SR.name,ext,liste)
    ELSE IF (SR.Name<>'.') AND (SR.name<>'..')
             AND (lowercase(copy(SR.name,length(SR.name)-3,4))='.'+ext)
         THEN
           IF NOT fileexists(there+SR.name)
           THEN  liste.add(here+SR.name+'@'+there+SR.name);
    application.processmessages;
    x:=FindNext(SR);
  END;
  FindClose(SR);
end;

procedure getQ2(here,there:string; var liste:tstringlist);
var
  SR:TSearchRec;
   x:integer;
begin
  IF here[length(here)]<>'\' THEN here:=here+'\';
  IF there[length(there)]<>'\' THEN there:=there+'\';

  x:=FindFirst(here+'*.*', $3F, SR);
  WHILE x=0 DO
  BEGIN
    IF ((SR.Attr AND faDirectory)>0) AND (SR.Name<>'.') AND (SR.name<>'..')
    THEN getQ2(here+SR.name,there+SR.name,liste)
    ELSE IF (SR.Name<>'.') AND (SR.name<>'..')
         THEN
           IF NOT fileexists(there+SR.name)
           THEN  liste.add(here+SR.name+'@'+there+SR.name);
    application.processmessages;
    x:=FindNext(SR);
  END;
  FindClose(SR);
end;

procedure syncCopy(imp,exp:tstringlist);
var ende,i:integer;
    logfile:tstringlist;
begin
  form1.enabled:=false;
  form6.show;
  form6.ProgressBar2.Position:=0;
  form6.repaint;
  ende:=imp.count+exp.count;
  form6.ProgressBar2.Max:=ende;
  continue:=true;
  logfile:=tstringlist.create;
  logfile.add('Syncronizing-Logfile generated by QLIFF');
  logfile.add('');
  logfile.add('Synchronize started at: '+DateTimeToStr(Now));
  logfile.add('');

  FOR i:=0 TO imp.count-1 DO
  BEGIN
    application.processmessages;
    IF continue=false THEN break;;
    form6.label23.Caption:='From: '+vorchar(imp[i],'@');
    form6.label1.Caption:='To: '+nachchar(imp[i],'@');
    Dateikopieren(vorchar(imp[i],'@'),nachchar(imp[i],'@'));
    logfile.add(vorchar(imp[i],'@')+' --> '+nachchar(imp[i],'@'));
    form6.ProgressBar2.StepIt;
  END;

  FOR i:=0 TO exp.count-1 DO
  BEGIN
    application.processmessages;
    IF continue=false THEN break;
    form6.label23.Caption:='From: '+vorchar(exp[i],'@');
    form6.label23.Caption:='To: '+nachchar(exp[i],'@');
    Dateikopieren(vorchar(exp[i],'@'),nachchar(exp[i],'@'));
    logfile.add(nachchar(exp[i],'@')+' <-- '+vorchar(exp[i],'@'));
    form6.ProgressBar2.StepIt;
  END;

  logfile.add('');
  logfile.add('Synchronize stopped at: '+DateTimeToStr(Now));
  IF form1.checkbox31.Checked THEN logfile.SaveToFile(verzeichnis+'sync.log');

  form1.enabled:=true;
  form6.close;
end;

procedure syncronisieren(typ:byte);
var exp,imp:tstringlist;
    here,there:string;

begin
  IF NOT isQ2folder(form1.edit4.text) THEN exit;
  form1.animate3.visible:=true;
  exp:=tstringlist.create;
  imp:=tstringlist.create;
  here:=extractfilepath(form1.FilenameEdit1.Text);
  IF form1.Edit4.text[length(form1.Edit4.text)]<>'\'
    THEN there:=form1.Edit4.text+'\';

  WITH form1 DO
  BEGIN
    IF (typ=1) OR (typ=3) THEN          //wenn exportiert werden soll
    BEGIN
{BSP} IF CheckBox22.checked
        THEN getIt(here+'baseq2\maps\'    ,there+'baseq2\maps\'    ,'bsp',exp);
{PAK} IF CheckBox23.checked
        THEN getPAKS(here+'baseq2\'       ,there+'baseq2\'               ,exp);
{WAD} IF CheckBox24.checked
        THEN getIt(here+'baseq2\textures\',there+'baseq2\textures\','wad',exp);
{TGA} IF CheckBox25.checked
        THEN getIt(here+'baseq2\env\'     ,there+'baseq2\env\'     ,'tga',exp);
{PCX} IF CheckBox25.checked
        THEN getIt(here+'baseq2\env\'     ,there+'baseq2\env\'     ,'pcx',exp);
{WAV} IF CheckBox26.checked
        THEN getIt(here+'baseq2\sound\'   ,there+'baseq2\sound\'   ,'wav',exp);
{MD2} IF CheckBox27.checked
        THEN getIt(here+'baseq2\players\' ,there+'baseq2\players\' ,'md2',exp);
{PCX} IF CheckBox27.checked
        THEN getIt(here+'baseq2\players\' ,there+'baseq2\players\' ,'pcx',exp);
{WAV} IF CheckBox27.checked
        THEN getIt(here+'baseq2\players\' ,there+'baseq2\players\' ,'wav',exp);
{RTZ} IF CheckBox28.checked
        THEN getIt(here+'eraser\routes\'  ,there+'eraser\routes\'  ,'rtz',exp);
{Q2}  IF CheckBox29.checked
        THEN getQ2(here                   ,there                         ,exp);

    END;
  END;

  WITH form1 DO
  BEGIN
    IF (typ=2) OR (typ=3) THEN          //wenn importiert werden soll
    BEGIN
{BSP} IF CheckBox22.checked
        THEN getIt(there+'baseq2\maps\'    ,here+'baseq2\maps\'    ,'bsp',imp);
{PAK} IF CheckBox23.checked
        THEN getPAKS(there+'baseq2\'       ,here+'baseq2\'               ,imp);
{WAD} IF CheckBox24.checked
        THEN getIt(there+'baseq2\textures\',here+'baseq2\textures\','wad',imp);
{TGA} IF CheckBox25.checked
        THEN getIt(there+'baseq2\env\'     ,here+'baseq2\env\'     ,'tga',imp);
{PCX} IF CheckBox25.checked
        THEN getIt(there+'baseq2\env\'     ,here+'baseq2\env\'     ,'pcx',imp);
{WAV} IF CheckBox26.checked
        THEN getIt(there+'baseq2\sound\'   ,here+'baseq2\sound\'   ,'wav',imp);
{MD2} IF CheckBox27.checked
        THEN getIt(there+'baseq2\players\' ,here+'baseq2\players\' ,'md2',imp);
{PCX} IF CheckBox27.checked
        THEN getIt(there+'baseq2\players\' ,here+'baseq2\players\' ,'pcx',imp);
{WAV} IF CheckBox27.checked
        THEN getIt(here+'baseq2\players\' ,there+'baseq2\players\' ,'wav',imp);
{RTZ} IF CheckBox28.checked
        THEN getIt(here+'eraser\routes\'  ,there+'eraser\routes\'  ,'rtz',imp);
{Q2}  IF CheckBox29.checked
        THEN getQ2(here                   ,there                         ,imp);
    END;
  END;
  form1.Animate3.visible:=false;
  synccopy(imp,exp);

  exp.free;
  imp.free;
end;


procedure markAll;
begin
  IF form1.checkbox29.checked THEN
  BEGIN
    form1.checkbox22.checked:=false;
    form1.checkbox23.checked:=false;
    form1.checkbox24.checked:=false;
    form1.checkbox25.checked:=false;
    form1.checkbox26.checked:=false;
    form1.checkbox27.checked:=false;
    form1.checkbox28.checked:=false;
  END;
end;

procedure TForm6.Button1Click(Sender: TObject);
begin
  continue:=false;
end;

procedure TForm6.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  continue:=false;
end;

end.
