unit tabelle;

interface

procedure import;       //liste importieren
procedure importlisteNEW(filename:string);
procedure exportliste;  //liste exportieren
procedure exportlisteNEW;  //liste exportieren in QLIFF2-Format
procedure exportsingle; //level exportieren
procedure exportsingleNEW; //level exportieren in QLIFF2-Format
procedure randommap;    //zufaelliges Level
procedure filterType;   //MapFiltern
procedure filterAus;    //Filter komplett abschalten
procedure alleloeschen; //Lscht alle Datensaetze

implementation
uses classes, main, andi, db, dialogs, controls, forms, BIGini, sysutils,
     userinfo;

procedure exportliste;
var datei:tstringlist;
    desc:string;
begin
  form1.savedialog1.filename:='qlifflevels.txt';
  IF form1.savedialog1.execute THEN
  BEGIN
    filteraus;
    datei:=tstringlist.create;
    WITH form1.Datasource1.Dataset DO
    BEGIN
      disablecontrols;
      FIRST;
      WHILE NOT eof DO
      BEGIN
        datei.add(fields[0].asstring);
        datei.add(fields[1].asstring);
        datei.add(fields[2].asstring);
        datei.add(fields[3].asstring);
        datei.add(fields[4].asstring);
        desc:=repS(fields[5].asstring,#13,'<CR>');
        desc:=repS(desc,#10,'<LF>');
        datei.add(desc);
        datei.add(fields[6].asstring);
        datei.add(fields[7].asstring);
        datei.add(fields[8].asstring);
        datei.add(fields[9].asstring);
        datei.add(fields[10].asstring);
        datei.add(fields[11].asstring);
        datei.add(fields[12].asstring);
        NEXT;
      END;
      enablecontrols;
    END;
    datei.savetoFile(form1.savedialog1.filename);
    whatSTRINGis('Export finished');
    datei.free;
  END;
end;

procedure exportlisteNEW;
var datei:tBIGinifile;
    desc:string;
    descCount:integer;
    count:integer;
begin
  form1.savedialog1.filename:='qlifflevels.qlf';
  IF form1.savedialog1.execute THEN
  IF user.ExportData(form1.savedialog1.filename) THEN
  BEGIN
    filteraus;
    datei:=tBIGinifile.create(form1.savedialog1.filename);


    count:=0;
    WITH form1.Datasource1.Dataset DO
    BEGIN
      disablecontrols;
      FIRST;
      screen.cursor:=crHourglass;
      WHILE NOT eof DO
      BEGIN
        inc(count);
        datei.writeinteger('HEADER','Levelcount',count);
        datei.writestring('MAP'+INTtoSTR(count),'FN',fields[0].asstring);
        datei.writestring('MAP'+INTtoSTR(count),'LN',fields[1].asstring);
        datei.writestring('MAP'+INTtoSTR(count),'MOD',fields[2].asstring);
        datei.writeinteger('MAP'+INTtoSTR(count),'MIN',fields[3].asinteger);
        datei.writeinteger('MAP'+INTtoSTR(count),'MAX',fields[4].asinteger);

        desc:=repS(fields[5].asstring,#13,'<CR>');
        desc:=repS(desc,#10,'<LF>');
        killspace(desc);
        descCount:=1;
        WHILE desc<>'' DO
        BEGIN
          datei.writestring('MAP'+INTtoSTR(count),'DSC'+INTtoSTR(descCount),shorten(desc));
          inc(descCount);
        END;

        datei.writebool('MAP'+INTtoSTR(count),'QUAD',fields[6].asboolean);
        datei.writebool('MAP'+INTtoSTR(count),'INV',fields[7].asboolean);
        datei.writebool('MAP'+INTtoSTR(count),'GL',fields[8].asboolean);
        datei.writebool('MAP'+INTtoSTR(count),'RL',fields[9].asboolean);
        datei.writebool('MAP'+INTtoSTR(count),'HB',fields[10].asboolean);
        datei.writebool('MAP'+INTtoSTR(count),'RG',fields[11].asboolean);
        datei.writebool('MAP'+INTtoSTR(count),'BFG',fields[12].asboolean);
        datei.writeinteger('MAP'+INTtoSTR(count),'RATE',fields[13].asinteger);
        application.processmessages;
        NEXT;
      END;
      screen.cursor:=crDefault;
      enablecontrols;
    END;
    whatSTRINGis('Export finished');
    datei.free;
  END;
end;

procedure importliste(filename:string);
var datei:tstringlist;
     satz:tstringlist;
     desc:string;

     none,all:boolean; //Alle oder keine ersetzen?
            x:word;    //rckgabewert der Messagebox

//interne Funktion
      procedure getDatensatz;
      var x:integer;
      BEGIN
        satz.Clear;
        FOR x:=0 TO 12 DO satz.add(datei[x]);
        FOR x:=0 TO 12 DO datei.delete(0);
      END;
   //interne Funktion ende

begin
  none:=false;
  all:=false;
  form1.Datasource1.Dataset.disablecontrols;
    filteraus;
    datei:=tstringlist.create;
    satz:=tstringlist.create;
    datei.loadfromfile(filename);

    WHILE datei.count>0 DO
    BEGIN
      getdatensatz;
      IF form1.table1.locate('Datei',satz[0],[loCaseInsensitive])
        THEN
        BEGIN

          IF (all=false) AND (none=false) THEN
          x:=messagedlg('The filename '+satz[0]+
                        ' does already exist!'+#10+#13+
                        'Do you want to replace the Record?',
                        mtConfirmation,
                       [mbNo,mbYes,mbYesToAll,mbNoToAll],0);

          IF x=mrYesToAll THEN all:=true;
          IF x=mrNoToAll THEN none:=true;

          IF (x=mrYes) OR (all=true) THEN
          BEGIN
            desc:=repS(satz[5],'<LF>',#10);
            desc:=repS(desc,'<CR>',#13);
            WHILE (copy(desc,1,4)='<LF>') OR (copy(desc,1,4)='<LF>') DO
            delete(desc,1,4);

            WITH form1.datasource1.DataSet DO
            BEGIN
            screen.cursor:=crHourglass;
            Edit;
            fields[1].asstring:=satz[1];
            fields[2].asstring:=satz[2];
            fields[3].asstring:=satz[3];
            fields[4].asstring:=satz[4];
            fields[5].asstring:=desc;

            IF satz[6]='Wahr' THEN fields[6].asboolean:=TRUE ELSE fields[6].asboolean:=FALSE;
            IF satz[7]='Wahr' THEN fields[7].asboolean:=TRUE ELSE fields[7].asboolean:=FALSE;
            IF satz[8]='Wahr' THEN fields[8].asboolean:=TRUE ELSE fields[8].asboolean:=FALSE;
            IF satz[9]='Wahr' THEN fields[9].asboolean:=TRUE ELSE fields[9].asboolean:=FALSE;
            IF satz[10]='Wahr' THEN fields[10].asboolean:=TRUE ELSE fields[10].asboolean:=FALSE;
            IF satz[11]='Wahr' THEN fields[11].asboolean:=TRUE ELSE fields[11].asboolean:=FALSE;
            IF satz[12]='Wahr' THEN fields[12].asboolean:=TRUE ELSE fields[12].asboolean:=FALSE;
            screen.cursor:=crDefault;
            END;
          END;

        END
        ELSE
        BEGIN
          screen.cursor:=crHourglass;
          desc:=repS(satz[5],'<LF>',#10);
          desc:=repS(desc,'<CR>',#13);
          killspace(desc);
          form1.datasource1.dataset.appendrecord([satz[0],satz[1],satz[2],satz[3],satz[4],
                                     desc,satz[6],satz[7],satz[8],satz[9],
                                     satz[10],satz[11],satz[12],'']);
          screen.cursor:=crDefault;
        END;
      application.processmessages;
    END;
    whatSTRINGis('Import Finished');
    datei.free;
    satz.Free;
    form1.Datasource1.Dataset.enablecontrols;
end;

procedure randommap;
var i:integer;
begin
  form1.table1.disablecontrols;
  randomize;
  FOR i:=0 TO round(random(form1.table1.FieldCount)*3) DO
    IF form1.table1.EOF
                THEN form1.table1.first
                ELSE form1.table1.next;
  form1.table1.enablecontrols;
end;

procedure exportsingle;
var datei:tstringlist;
    desc:string;
begin
  form1.savedialog1.filename:=form1.DBEdit1.text+'.txt';
  IF form1.savedialog1.execute THEN
  BEGIN
    filteraus;
    datei:=tstringlist.create;
    WITH form1.Datasource1.Dataset DO
    BEGIN
      disablecontrols;
        datei.add(fields[0].asstring);
        datei.add(fields[1].asstring);
        datei.add(fields[2].asstring);
        datei.add(fields[3].asstring);
        datei.add(fields[4].asstring);
        desc:=repS(fields[5].asstring,#13,'<CR>');
        desc:=repS(desc,#10,'<LF>');
        datei.add(desc);
        datei.add(fields[6].asstring);
        datei.add(fields[7].asstring);
        datei.add(fields[8].asstring);
        datei.add(fields[9].asstring);
        datei.add(fields[10].asstring);
        datei.add(fields[11].asstring);
        datei.add(fields[12].asstring);
      enablecontrols;
    END;
    datei.savetoFile(form1.savedialog1.filename);
    whatSTRINGis('Export finished');
    datei.free;
  END;
end;

procedure exportsingleNEW;
var datei:tBIGinifile;
    desc:string;
    descCount:integer;
begin
  form1.savedialog1.filename:=form1.DBEdit1.text+'.qlf';
  IF form1.savedialog1.execute THEN
  IF user.ExportData(form1.savedialog1.filename) THEN
  BEGIN
    filteraus;
    datei:=tBIGinifile.create(form1.savedialog1.filename);
    WITH form1.Datasource1.Dataset DO
    BEGIN
      disablecontrols;
        datei.writeinteger('HEADER','Levelcount',1);
        datei.writestring('MAP1','FN',fields[0].asstring);
        datei.writestring('MAP1','LN',fields[1].asstring);
        datei.writestring('MAP1','MOD',fields[2].asstring);
        datei.writeinteger('MAP1','MIN',fields[3].asinteger);
        datei.writeinteger('MAP1','MAX',fields[4].asinteger);
        desc:=repS(fields[5].asstring,#13,'<CR>');
        desc:=repS(desc,#10,'<LF>');
        killspace(desc);
        descCount:=1;
        WHILE desc<>'' DO
        BEGIN
          datei.writestring('MAP1','DSC'+INTtoSTR(descCount),shorten(desc));
          inc(descCount);
        END;
        //datei.writestring('MAP1','DSC',desc);
        datei.writebool('MAP1','QUAD',fields[6].asboolean);
        datei.writebool('MAP1','INV',fields[7].asboolean);
        datei.writebool('MAP1','GL',fields[8].asboolean);
        datei.writebool('MAP1','RL',fields[9].asboolean);
        datei.writebool('MAP1','HB',fields[10].asboolean);
        datei.writebool('MAP1','RG',fields[11].asboolean);
        datei.writebool('MAP1','BFG',fields[12].asboolean);
        datei.writeinteger('MAP1','RATE',fields[13].asinteger);
      enablecontrols;
    END;
    whatSTRINGis('Export finished');
    datei.free;
  END;
end;

procedure filterType;
begin
  IF form1.ComboBox1.Text='No Filter' THEN form1.RxDBFilter1.Deactivate ELSE
  BEGIN
    form1.RxDBFilter1.Filter[0]:='Typ = '''+form1.ComboBox1.text+'''';
    form1.RxDBFilter1.Activate
  END;
  form1.DataSource1.DataSet.Refresh;
end;

procedure filterAus;
begin
  form1.RxDBFilter1.deActivate;
  form1.ComboBox1.ItemIndex:=0;
  form1.DataSource1.DataSet.Refresh;
end;

procedure alleloeschen;
begin
  IF messagedlg('This will DELETE ALL entries in your Database!'
               +#10+#13
               +'Do you want to continue?',mtWarning,[mbYes, mbNo],0)=mrYes
  THEN
  BEGIN
    screen.cursor:=crHourglass;
    WITH form1.DataSource1.DataSet DO
      WHILE recordcount>0 DO delete;
    screen.cursor:=crDefault;
  END;
end;

procedure importlisteNEW(filename:string);
var  datei:tBIGinifile;
     desc:string;
     descCount:integer;

     none,all:boolean; //Alle oder keine ersetzen?
            x:word;    //rckgabewert der Messagebox
            i:integer;
begin
  none:=false;
  all:=false;
  IF user.ImportData(filename) THEN
  BEGIN
    form1.Datasource1.Dataset.disablecontrols;
    filteraus;
    datei:=tBIGinifile.create(filename);
    FOR i:=1 TO datei.readinteger('HEADER','Levelcount',1) DO
    BEGIN
      IF form1.table1.locate('Datei',datei.readstring('MAP'+INTtoSTR(i),'FN',''),[loCaseInsensitive])
        THEN
        BEGIN

          IF (all=false) AND (none=false) THEN
          x:=messagedlg('The filename '+datei.readstring('MAP'+INTtoSTR(i),'FN','')+
                        ' does already exist!'+#10+#13+
                        'Do you want to replace the Record?',
                        mtConfirmation,
                       [mbNo,mbYes,mbYesToAll,mbNoToAll],0);

          IF x=mrYesToAll THEN all:=true;
          IF x=mrNoToAll THEN none:=true;

          IF (x=mrYes) OR (all=true) THEN
          BEGIN
            screen.cursor:=crHourglass;

            descCount:=1;
            desc:='';
            WHILE datei.readstring('MAP'+INTtoSTR(i),'DSC'+INTtoSTR(descCount),'')<>'' DO
            BEGIN
              desc:=desc+datei.readstring('MAP'+INTtoSTR(i),'DSC'+INTtoSTR(descCount),'');
              inc(descCount);
            END;

            desc:=repS(desc,'<LF>',#10);
            desc:=repS(desc,'<CR>',#13);
            killspace(desc);

            WITH form1.datasource1.DataSet DO
            BEGIN
            Edit;
            fields[1].asstring:=datei.readstring('MAP'+INTtoSTR(i),'LN','');
            fields[2].asstring:=datei.readstring('MAP'+INTtoSTR(i),'MOD','');
            fields[3].asinteger:=datei.readinteger('MAP'+INTtoSTR(i),'MIN',1);
            fields[4].asinteger:=datei.readinteger('MAP'+INTtoSTR(i),'MAX',1);
            fields[5].asstring:=desc;
            fields[6].asboolean:=datei.readbool('MAP'+INTtoSTR(i),'QUAD',FALSE);
            fields[7].asboolean:=datei.readbool('MAP'+INTtoSTR(i),'INV',FALSE);
            fields[8].asboolean:=datei.readbool('MAP'+INTtoSTR(i),'GL',FALSE);
            fields[9].asboolean:=datei.readbool('MAP'+INTtoSTR(i),'RL',FALSE);
            fields[10].asboolean:=datei.readbool('MAP'+INTtoSTR(i),'HB',FALSE);
            fields[11].asboolean:=datei.readbool('MAP'+INTtoSTR(i),'RG',FALSE);
            fields[12].asboolean:=datei.readbool('MAP'+INTtoSTR(i),'BFG',FALSE);
            fields[13].asinteger:=datei.readinteger('MAP'+INTtoSTR(i),'RATE',0);
            Post;
            END;
            screen.cursor:=crdefault;
          END;

        END
        ELSE
        BEGIN
          screen.cursor:=crHourglass;

          descCount:=1;
          desc:='';
            WHILE datei.readstring('MAP'+INTtoSTR(i),'DSC'+INTtoSTR(descCount),'')<>'' DO
            BEGIN
              desc:=desc+datei.readstring('MAP'+INTtoSTR(i),'DSC'+INTtoSTR(descCount),'');
              inc(descCount);
            END;

          desc:=repS(desc,'<LF>',#10);
          desc:=repS(desc,'<CR>',#13);
          killspace(desc);
          form1.datasource1.dataset.appendrecord([datei.readstring('MAP'+INTtoSTR(i),'FN',''),
                                                  datei.readstring('MAP'+INTtoSTR(i),'LN',''),
                                                  datei.readstring('MAP'+INTtoSTR(i),'MOD',''),
                                                  datei.readinteger('MAP'+INTtoSTR(i),'MIN',1),
                                                  datei.readinteger('MAP'+INTtoSTR(i),'MAX',1),
                                                  desc,
                                                  datei.readbool('MAP'+INTtoSTR(i),'QUAD',FALSE),
                                                  datei.readbool('MAP'+INTtoSTR(i),'INV',FALSE),
                                                  datei.readbool('MAP'+INTtoSTR(i),'GL',FALSE),
                                                  datei.readbool('MAP'+INTtoSTR(i),'RL',FALSE),
                                                  datei.readbool('MAP'+INTtoSTR(i),'HB',FALSE),
                                                  datei.readbool('MAP'+INTtoSTR(i),'RG',FALSE),
                                                  datei.readbool('MAP'+INTtoSTR(i),'BFG',FALSE),
                                                  datei.readinteger('MAP'+INTtoSTR(i),'RATE',0)]);
          screen.cursor:=crDefault;
        END;
        application.processmessages;
    END;
    whatSTRINGis('Import Finished');
    datei.free;
    form1.Datasource1.Dataset.enablecontrols;
  END;
end;

procedure import;
begin
  IF form1.OpenDialog1.execute THEN
    IF lowercase(ExtractFileExt(form1.opendialog1.filename))='.qlf'
    THEN importListeNEW(form1.opendialog1.filename)
    ELSE importListe(form1.opendialog1.filename);
end;

end.
