unit userinfo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TUser = class(TForm)
    Info: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Version: TEdit;
    Text: TLabel;
    Label4: TLabel;
    Language: TComboBox;
    function ImportData(filename:string):boolean;
    function ExportData(filename:string):boolean;
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  User: TUser;

implementation
uses bigini, andi;

{$R *.DFM}

function TUser.ImportData(filename:string):boolean;
var datei:tbiginifile;
     desc:string;
     desccount:integer;
begin
  datei:=tbiginifile.create(filename);
  Version.Enabled:=false;
  Language.enabled:=false;
  Info.Readonly:=true;
  Text.caption:='This are the Informations provided with the File you want to import.'+
                #13+#10+
                'Read everything careful and if you still want to import the Data press OK!';
  Version.text:=datei.readstring('HEADER','Version','n/a');
  Language.text:=datei.readstring('HEADER','Lang','n/a');

  descCount:=1;
  desc:='';
  WHILE datei.readstring('HEADER','Info'+INTtoSTR(descCount),'')<>'' DO
  BEGIN
    desc:=desc+datei.readstring('HEADER','Info'+INTtoSTR(descCount),'');
    inc(descCount);
  END;
  desc:=repS(desc,'<CR>',#13);
  desc:=repS(desc,'<LF>',#10);
  killspace(desc);
  Info.text:=desc;
  IF showmodal=mrOK THEN result:=true ELSE result:=false;
  datei.free;
end;

function TUser.ExportData(filename:string):boolean;
var datei,datei2:tbiginifile;
     desc:string;
     desccount:integer;
begin
  datei:=tbiginifile.create(verzeichnis+'user.ini');
  Version.Enabled:=false;
  Language.enabled:=true;
  Info.readonly:=false;
  Text.caption:='Please enter the Informations you want to store within your Exportfiles.';

  Version.text:=fileversion;
  Language.text:=datei.readstring('HEADER','Lang','English');

  descCount:=1;
  desc:='';
  WHILE datei.readstring('HEADER','Info'+INTtoSTR(descCount),'')<>'' DO
  BEGIN
    desc:=desc+datei.readstring('HEADER','Info'+INTtoSTR(descCount),'');
    inc(descCount);
  END;

  desc:=repS(desc,'<CR>',#13);
  desc:=repS(desc,'<LF>',#10);

  killspace(desc);
  Info.text:=desc;
  IF showmodal=mrOK THEN
    BEGIN
      IF fileexists(FileName) THEN deletefile(fileName);
      datei2:=tbiginifile.create(filename);
      datei.writestring('HEADER','Lang',Language.text);

      desc:=repS(Info.text,#13,'<CR>');
      desc:=repS(desc,#10,'<LF>');
      killspace(desc);

      descCount:=1;
      WHILE datei.readstring('HEADER','Info'+INTtoSTR(descCount),'')<>'' DO
      BEGIN
        datei.writestring('HEADER','Info'+INTtoSTR(descCount),'');
        inc(descCount);
      END;
      descCount:=1;
      WHILE desc<>'' DO
        BEGIN
          datei.writestring('HEADER','Info'+INTtoSTR(descCount),shorten(desc));
          inc(descCount);
        END;


//      datei.writestring('HEADER','Info',desc);

      datei2.writestring('HEADER','Version',Version.text);
      datei2.writestring('HEADER','Lang',user.Language.text);
      desc:=repS(Info.text,#13,'<CR>');
      desc:=repS(desc,#10,'<LF>');
      killspace(desc);
      descCount:=1;
      WHILE desc<>'' DO
        BEGIN
          datei2.writestring('HEADER','Info'+INTtoSTR(descCount),shorten(desc));
          inc(descCount);
        END;
      result:=true;
      datei2.free;
    END
    ELSE result:=false;
  datei.free;
  
end;

end.


